function [ddata,ptloc] = prepost_sim(iter,prepost,type)
%This is a test similation to look at the behavior of different synapse
%classification algorithms.  Specifically how modifications of the prepost
%filter from punc_colo works.  There a couple of assumptions, the ori point
%is 0,0 and the termi point is 0,5.  All points randomly generated will be
%between -10 to 10.  The prepost filter is assummed to want to be near the
%ori (e.g., GluR to PSD95).
%   ddata = the distance data of each point that is verifided, so distance
%           to ori and distance to termi, modified distance to ori. struct
%           fields: dori,dtermi
%   ptloc = the actual location of the point in x,y, structure fields:
%           ptkept, ptlost
%   iter = the # of iterations desired
%   prepost = the prepost filter number
%   type = the algorithm type, by default type 0 = no mod

if nargin < 3
    type = 0;   %set default
end

pp_ori = [0 0 0];
pp_termi = [0 5 0];
drange = 10;    %points range max


%generate random points
pp_comp = rand(iter,3)*drange;  %numbers within range
%now give them random signs
pp_sign = rand(iter,3);
pp_sign(pp_sign<0.5) = -1;
pp_sign(pp_sign>0.5) = 1;
%finalize points
pp_comp = pp_comp.*pp_sign;

%initialize
dori = zeros(iter,1);
dtermi = zeros(iter,1);

for j = 1:size(type,2)  %multiple types accepted
    ptkept = pp_comp;   %assign
    for i = 1:iter
        curr_dori = dddist(pp_ori,pp_comp(i,:));    %curr ori distance
        curr_dtermi = dddist(pp_termi,pp_comp(i,:));  %curr termi distance
        switch type(j)
            case 1  %divide
                ypp(i,1) = curr_dori>curr_dtermi/abs(prepost);  %ori must be closer than termi
            case 2  %shift
                ypp(i,1) = curr_dori>curr_dtermi-prepost;  %ori must be closer than termi
            otherwise %no mod
                ypp(i,1) = curr_dori>curr_dtermi;  %ori must be closer than termi
        end
        if ~ypp(i,1)  %passed
            dori(i,:) = curr_dori;
            dtermi(i,:) = curr_dtermi;
        end
    end
    ypp = find(ypp==1);     %create actual index
    ptlost = ptkept(ypp,:);        %lost points
    ptkept(ypp,:) = [];        %get gone kept points
    
    %for 3d simulation
    ptkept = flat_verts(ptkept);
    ptlost = flat_verts(ptlost);
    
    %plot
    figure('Name',['Points Kept-type',num2str(type(j)),':',num2str(size(ptkept,1))],'NumberTitle','off');scatter(ptkept(:,1),ptkept(:,2),'*');
    figure('Name',['Points Lost-type',num2str(type(j)),':',num2str(size(ptlost,1))],'NumberTitle','off');scatter(ptlost(:,1),ptlost(:,2),'*');
    %output data
    ddata(j).dori = dori;
    ddata(j).dtermi = dtermi;
    
    ptloc(j).ptlost = ptlost;
    ptloc(j).ptkept = ptkept;
end

